IF OBJECT_ID('PG_CRED_IMPOSTO_VINCULADO') IS NULL
begin
CREATE TABLE [dbo].[PG_CRED_IMPOSTO_VINCULADO](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_PG_CRED] [int] NOT NULL,
	[CD_IMP] [int] NOT NULL,
 CONSTRAINT [PK_PG_CRED_IMPOSTO_VINCULADO] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_PG_CRED] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[PG_CRED_IMPOSTO_VINCULADO] ADD  CONSTRAINT [DF_PG_CRED_IMPOSTO_VINCULADO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[PG_CRED_IMPOSTO_VINCULADO] ADD  CONSTRAINT [DF_PG_CRED_IMPOSTO_VINCULADO_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[PG_CRED_IMPOSTO_VINCULADO] ADD  CONSTRAINT [DF_PG_CRED_IMPOSTO_VINCULADO_CD_PG_CRED]  DEFAULT ((0)) FOR [CD_PG_CRED]

ALTER TABLE [dbo].[PG_CRED_IMPOSTO_VINCULADO] ADD  CONSTRAINT [DF_PG_CRED_IMPOSTO_VINCULADO_CD_IMP]  DEFAULT ((0)) FOR [CD_IMP]

ALTER TABLE [dbo].[PG_CRED_IMPOSTO_VINCULADO]  WITH CHECK ADD  CONSTRAINT [FK_PG_CRED_IMPOSTO_VINCULADO_GLB_IMPOSTOS] FOREIGN KEY([CD_IMP])
REFERENCES [dbo].[GLB_IMPOSTOS] ([CD_CTR])

ALTER TABLE [dbo].[PG_CRED_IMPOSTO_VINCULADO] CHECK CONSTRAINT [FK_PG_CRED_IMPOSTO_VINCULADO_GLB_IMPOSTOS]

ALTER TABLE [dbo].[PG_CRED_IMPOSTO_VINCULADO]  WITH CHECK ADD  CONSTRAINT [FK_PG_CRED_IMPOSTO_VINCULADO_PG_CRED] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PG_CRED])
REFERENCES [dbo].[PG_CRED] ([CD_EMP], [CD_FILIAL], [CD_PG_CRED])
ON UPDATE CASCADE
ON DELETE CASCADE

ALTER TABLE [dbo].[PG_CRED_IMPOSTO_VINCULADO] CHECK CONSTRAINT [FK_PG_CRED_IMPOSTO_VINCULADO_PG_CRED]
end
